/*
 * prodcons.c - producers-consumers
 */

#include <stdio.h>
#include <pthread.h>
#include <unistd.h>


#define N_PROD 2
#define N_CONS 2
#define N_ELEMS 10

int Buffer[N_ELEMS];


void* thr_producer(void* ptr)
{
   int id = *((int*)ptr);

   while (1) {
      printf("[P %d] Producing item...\n",id);
      sleep(1);
   }
   return NULL;
}


void* thr_consumer(void* ptr)
{
   int id = *((int*)ptr);

   while (1) {
      printf("[C %d] Consuming item...\n",id);
      sleep(1);
   }
   return NULL;
}


int main()
{
   pthread_t tid_p[N_PROD], tid_c[N_CONS];
   int id_p[N_PROD], id_c[N_CONS];
   int i;

   for (i = 0; i < N_PROD; i++) {
      id_p[i] = i;
      if (pthread_create(&tid_p[i], NULL, thr_producer, (void*)&id_p[i]) != 0){
         printf("Error creating thread.\n");
         return -1;
      }
   }
    
   for (i = 0; i < N_CONS; i++) {
      id_c[i] = i;
      if (pthread_create(&tid_c[i], NULL, thr_consumer, (void*)&id_c[i]) != 0){
         printf("Error creating thread.\n");
         return -1;
      }
   }
    
   for (i = 0; i < N_PROD; i++) {
      if(pthread_join(tid_p[i], NULL) != 0) {
         printf("Error joining thread.\n");
         return -1;
      }
   }

   for (i = 0; i < N_CONS; i++) {
      if(pthread_join(tid_c[i], NULL) != 0) {
         printf("Error joining thread.\n");
         return -1;
      }
   }

   printf("Done.\n");
   return 0;
}
